/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel;

import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyReferenceData;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModelContext;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.internal.ws.policy.spi.PrefixMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class PolicySourceModel
implements Cloneable {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicySourceModel.class);
    private static final Map<String, String> DEFAULT_NAMESPACE_TO_PREFIX = new HashMap<String, String>();
    private final Map<String, String> namespaceToPrefix = new HashMap<String, String>(DEFAULT_NAMESPACE_TO_PREFIX);
    private ModelNode rootNode;
    private final String policyId;
    private final String policyName;
    private final NamespaceVersion nsVersion;
    private final List<ModelNode> references = new LinkedList<ModelNode>();
    private boolean expanded = false;

    public static PolicySourceModel createPolicySourceModel(NamespaceVersion namespaceVersion) {
        return new PolicySourceModel(namespaceVersion);
    }

    public static PolicySourceModel createPolicySourceModel(NamespaceVersion namespaceVersion, String string, String string2) {
        return new PolicySourceModel(namespaceVersion, string, string2);
    }

    private PolicySourceModel(NamespaceVersion namespaceVersion) {
        this(namespaceVersion, null, null);
    }

    private PolicySourceModel(NamespaceVersion namespaceVersion, String string, String string2) {
        this(namespaceVersion, string, string2, null);
    }

    protected PolicySourceModel(NamespaceVersion namespaceVersion, String string, String string2, Collection<PrefixMapper> collection) {
        this.rootNode = ModelNode.createRootPolicyNode(this);
        this.nsVersion = namespaceVersion;
        this.policyId = string;
        this.policyName = string2;
        if (collection != null) {
            for (PrefixMapper prefixMapper : collection) {
                this.namespaceToPrefix.putAll(prefixMapper.getPrefixMap());
            }
        }
    }

    public ModelNode getRootNode() {
        return this.rootNode;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public NamespaceVersion getNamespaceVersion() {
        return this.nsVersion;
    }

    Map<String, String> getNamespaceToPrefixMapping() throws PolicyException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Collection<String> collection = this.getUsedNamespaces();
        for (String string : collection) {
            String string2 = this.getDefaultPrefix(string);
            if (string2 == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PolicySourceModel)) {
            return false;
        }
        boolean bl = true;
        PolicySourceModel policySourceModel = (PolicySourceModel)object;
        boolean bl2 = bl && (this.policyId == null ? policySourceModel.policyId == null : this.policyId.equals(policySourceModel.policyId)) ? true : (bl = false);
        bl = bl && (this.policyName == null ? policySourceModel.policyName == null : this.policyName.equals(policySourceModel.policyName));
        bl = bl && this.rootNode.equals(policySourceModel.rootNode);
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.policyId == null ? 0 : this.policyId.hashCode());
        n = 37 * n + (this.policyName == null ? 0 : this.policyName.hashCode());
        n = 37 * n + this.rootNode.hashCode();
        return n;
    }

    public String toString() {
        String string = PolicyUtils.Text.createIndent(1);
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append("Policy source model {").append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string).append("policy id = '").append(this.policyId).append('\'').append(PolicyUtils.Text.NEW_LINE);
        stringBuffer.append(string).append("policy name = '").append(this.policyName).append('\'').append(PolicyUtils.Text.NEW_LINE);
        this.rootNode.toString(1, stringBuffer).append(PolicyUtils.Text.NEW_LINE).append('}');
        return stringBuffer.toString();
    }

    protected PolicySourceModel clone() throws CloneNotSupportedException {
        PolicySourceModel policySourceModel = (PolicySourceModel)super.clone();
        policySourceModel.rootNode = this.rootNode.clone();
        try {
            policySourceModel.rootNode.setParentModel(policySourceModel);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw LOGGER.logSevereException(new CloneNotSupportedException(LocalizationMessages.WSP_0013_UNABLE_TO_SET_PARENT_MODEL_ON_ROOT()), illegalAccessException);
        }
        return policySourceModel;
    }

    public boolean containsPolicyReferences() {
        return !this.references.isEmpty();
    }

    private boolean isExpanded() {
        return this.references.isEmpty() || this.expanded;
    }

    public synchronized void expand(PolicySourceModelContext policySourceModelContext) throws PolicyException {
        if (!this.isExpanded()) {
            for (ModelNode modelNode : this.references) {
                PolicyReferenceData policyReferenceData = modelNode.getPolicyReferenceData();
                String string = policyReferenceData.getDigest();
                PolicySourceModel policySourceModel = string == null ? policySourceModelContext.retrieveModel(policyReferenceData.getReferencedModelUri()) : policySourceModelContext.retrieveModel(policyReferenceData.getReferencedModelUri(), policyReferenceData.getDigestAlgorithmUri(), string);
                modelNode.setReferencedModel(policySourceModel);
            }
            this.expanded = true;
        }
    }

    void addNewPolicyReference(ModelNode modelNode) {
        if (modelNode.getType() != ModelNode.Type.POLICY_REFERENCE) {
            throw new IllegalArgumentException(LocalizationMessages.WSP_0042_POLICY_REFERENCE_NODE_EXPECTED_INSTEAD_OF((Object)modelNode.getType()));
        }
        this.references.add(modelNode);
    }

    private Collection<String> getUsedNamespaces() throws PolicyException {
        ModelNode modelNode;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getNamespaceVersion().toString());
        if (this.policyId != null) {
            hashSet.add("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        LinkedList<ModelNode> linkedList = new LinkedList<ModelNode>();
        linkedList.add(this.rootNode);
        while ((modelNode = (ModelNode)linkedList.poll()) != null) {
            for (ModelNode modelNode2 : modelNode.getChildren()) {
                if (modelNode2.hasChildren() && !linkedList.offer(modelNode2)) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0081_UNABLE_TO_INSERT_CHILD(linkedList, modelNode2)));
                }
                if (!modelNode2.isDomainSpecific()) continue;
                AssertionData assertionData = modelNode2.getNodeData();
                hashSet.add(assertionData.getName().getNamespaceURI());
                if (assertionData.isPrivateAttributeSet()) {
                    hashSet.add("http://java.sun.com/xml/ns/wsit/policy");
                }
                for (Map.Entry<QName, String> entry : assertionData.getAttributesSet()) {
                    hashSet.add(entry.getKey().getNamespaceURI());
                }
            }
        }
        return hashSet;
    }

    private String getDefaultPrefix(String string) {
        return this.namespaceToPrefix.get(string);
    }

    static {
        PrefixMapper[] prefixMapperArray = PolicyUtils.ServiceProvider.load(PrefixMapper.class);
        if (prefixMapperArray != null) {
            for (PrefixMapper prefixMapper : prefixMapperArray) {
                DEFAULT_NAMESPACE_TO_PREFIX.putAll(prefixMapper.getPrefixMap());
            }
        }
        for (NamespaceVersion namespaceVersion : NamespaceVersion.values()) {
            DEFAULT_NAMESPACE_TO_PREFIX.put(namespaceVersion.toString(), namespaceVersion.getDefaultNamespacePrefix());
        }
        DEFAULT_NAMESPACE_TO_PREFIX.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        DEFAULT_NAMESPACE_TO_PREFIX.put("http://java.sun.com/xml/ns/wsit/policy", "sunwsp");
    }
}

